/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BuddingAmethystBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import xfacthd.buddingcrystals.common.util.BudSet;

public final class BuddingCrystalBlock
extends BuddingAmethystBlock {
    private static final Direction[] DIRECTIONS = Direction.values();
    private final BudSet budSet;
    private final int growthChance;

    public BuddingCrystalBlock(BudSet budSet, int growthChance, BlockBehaviour.Properties properties) {
        super(properties);
        this.budSet = budSet;
        this.growthChance = growthChance;
    }

    public void m_7455_(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (random.nextInt(this.growthChance) == 0) {
            Direction side = DIRECTIONS[random.nextInt(DIRECTIONS.length)];
            BlockPos neighborPos = pos.m_142300_(side);
            BlockState neighborState = level.m_8055_(neighborPos);
            Block block = null;
            if (BuddingCrystalBlock.m_152734_((BlockState)neighborState)) {
                block = this.budSet.getSmallBud();
            } else if (neighborState.m_60713_(this.budSet.getSmallBud()) && BuddingCrystalBlock.sameFacing(neighborState, side)) {
                block = this.budSet.getMediumBud();
            } else if (neighborState.m_60713_(this.budSet.getMediumBud()) && BuddingCrystalBlock.sameFacing(neighborState, side)) {
                block = this.budSet.getLargeBud();
            } else if (neighborState.m_60713_(this.budSet.getLargeBud()) && BuddingCrystalBlock.sameFacing(neighborState, side)) {
                block = this.budSet.getCluster();
            }
            if (block != null) {
                BlockState newState = (BlockState)((BlockState)block.m_49966_().m_61124_((Property)AmethystClusterBlock.f_152006_, (Comparable)side)).m_61124_((Property)AmethystClusterBlock.f_152005_, (Comparable)Boolean.valueOf(neighborState.m_60819_().m_76152_() == Fluids.f_76193_));
                level.m_46597_(neighborPos, newState);
            }
        }
    }

    private static boolean sameFacing(BlockState state, Direction side) {
        return state.m_61143_((Property)AmethystClusterBlock.f_152006_) == side;
    }
}

